/*
 * start rewrite from:
 * https://github.com/adafruit/Adafruit-GFX-Library.git
 * https://github.com/daumemo/IPS_LCD_NT35310_FT6236_Arduino_eSPI_Test
 */
#include "Arduino_NT35310.h"

Arduino_NT35310::Arduino_NT35310(
    Arduino_DataBus *bus, int8_t rst, uint8_t r,
    bool ips, int16_t w, int16_t h,
    uint8_t col_offset1, uint8_t row_offset1, uint8_t col_offset2, uint8_t row_offset2)
    : Arduino_TFT(bus, rst, r, ips, w, h, col_offset1, row_offset1, col_offset2, row_offset2)
{
}

void Arduino_NT35310::begin(int32_t speed)
{
  Arduino_TFT::begin(speed);
}

void Arduino_NT35310::writeAddrWindow(int16_t x, int16_t y, uint16_t w, uint16_t h)
{
  if ((x != _currentX) || (w != _currentW))
  {
    _bus->writeC8D16D16(NT35310_SET_HORIZONTAL_ADDRESS, x + _xStart, x + w - 1 + _xStart);

    _currentX = x;
    _currentW = w;
  }
  if ((y != _currentY) || (h != _currentH))
  {
    _bus->writeC8D16D16(NT35310_SET_VERTICAL_ADDRESS, y + _yStart, y + h - 1 + _yStart);

    _currentY = y;
    _currentH = h;
  }

  _bus->writeCommand(NT35310_WRITE_MEMORY_START); // write to RAM
}

/**************************************************************************/
/*!
    @brief   Set origin of (0,0) and orientation of TFT display
    @param   m  The index for rotation, from 0-3 inclusive
*/
/**************************************************************************/
void Arduino_NT35310::setRotation(uint8_t r)
{
  Arduino_TFT::setRotation(r);
  switch (_rotation)
  {
  case 3:
    r = NT35310_MADCTL_MY | NT35310_MADCTL_MV | NT35310_MADCTL_RGB;
    break;
  case 2:
    r = NT35310_MADCTL_MY | NT35310_MADCTL_MX | NT35310_MADCTL_RGB;
    break;
  case 1:
    r = NT35310_MADCTL_MX | NT35310_MADCTL_MV | NT35310_MADCTL_RGB;
    break;
  default: // case 0:
    r = NT35310_MADCTL_RGB;
    break;
  }
  _bus->beginWrite();
  _bus->writeCommand(NT35310_SET_ADDRESS_MODE);
  _bus->write(r);
  _bus->endWrite();
}

void Arduino_NT35310::invertDisplay(bool i)
{
  _bus->sendCommand((_ips ^ i) ? NT35310_ENTER_INVERT_MODE : NT35310_EXIT_INVERT_MODE);
}

void Arduino_NT35310::displayOn(void)
{
  _bus->sendCommand(NT35310_EXIT_SLEEP_MODE);
  delay(NT35310_SLPOUT_DELAY);
}

void Arduino_NT35310::displayOff(void)
{
  _bus->sendCommand(NT35310_ENTER_SLEEP_MODE);
  delay(NT35310_SLPIN_DELAY);
}

void Arduino_NT35310::tftInit()
{
  if (_rst != GFX_NOT_DEFINED)
  {
    pinMode(_rst, OUTPUT);
    digitalWrite(_rst, HIGH);
    delay(100);
    digitalWrite(_rst, LOW);
    delay(NT35310_RST_DELAY);
    digitalWrite(_rst, HIGH);
    delay(NT35310_RST_DELAY);
  }
  else
  {
    // Software Rest
    _bus->sendCommand(NT35310_SOFT_RESET);
    delay(NT35310_RST_DELAY);
  }

  uint8_t nt35310_init_operations[] = {
      BEGIN_WRITE,
      WRITE_C8_D16, NT35310_PAGE_CTRL, 0x01, 0xFE,

      WRITE_C8_D16, 0xEE, 0xDE, 0x21, // PAGE_CTRL Into CMD3

      WRITE_C8_D8, 0xF1, 0x01,
      WRITE_C8_D8, 0xDF, 0x10,

      //VCOMvoltage//
      WRITE_C8_D8, NT35310_PWR_CTRL6, 0x8F, //5f

      WRITE_COMMAND_8, NT35310_PWR_CTRL8,
      WRITE_BYTES, 4, 0x00, 0xE2, 0xE2, 0xE2,

      WRITE_C8_D8, NT35310_PAGE_LOCK2, 0xAA,

      WRITE_COMMAND_8, 0xB0,
      WRITE_BYTES, 18,
      0x0D, 0x00, 0x0D, 0x00, 0x11,
      0x00, 0x19, 0x00, 0x21, 0x00,
      0x2D, 0x00, 0x3D, 0x00, 0x5D,
      0x00, 0x5D, 0x00,

      WRITE_COMMAND_8, 0xB1,
      WRITE_BYTES, 6,
      0x80, 0x00, 0x8B, 0x00, 0x96,
      0x00,

      WRITE_COMMAND_8, 0xB2,
      WRITE_BYTES, 6,
      0x00, 0x00, 0x02, 0x00, 0x03,
      0x00,

      WRITE_COMMAND_8, 0xB3,
      WRITE_BYTES, 24,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00,

      WRITE_COMMAND_8, 0xB4,
      WRITE_BYTES, 6,
      0x8B, 0x00, 0x96, 0x00, 0xA1,
      0x00,

      WRITE_COMMAND_8, 0xB5,
      WRITE_BYTES, 6,
      0x02, 0x00, 0x03, 0x00, 0x04,
      0x00,

      WRITE_C8_D16, 0xB6, 0x00, 0x00,

      WRITE_COMMAND_8, 0xB7,
      WRITE_BYTES, 22,
      0x00, 0x00, 0x3F, 0x00, 0x5E,
      0x00, 0x64, 0x00, 0x8C, 0x00,
      0xAC, 0x00, 0xDC, 0x00, 0x70,
      0x00, 0x90, 0x00, 0xEB, 0x00,
      0xDC, 0x00,

      WRITE_COMMAND_8, 0xB8,
      WRITE_BYTES, 8,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00,

      WRITE_COMMAND_8, 0xBA,
      WRITE_BYTES, 4,
      0x24, 0x00, 0x00, 0x00,

      WRITE_COMMAND_8, 0xC1,
      WRITE_BYTES, 6,
      0x20, 0x00, 0x54, 0x00, 0xFF,
      0x00,

      WRITE_COMMAND_8, 0xC2,
      WRITE_BYTES, 4,
      0x0A, 0x00, 0x04, 0x00,

      WRITE_COMMAND_8, 0xC3,
      WRITE_BYTES, 48,
      0x3C, 0x00, 0x3A, 0x00, 0x39,
      0x00, 0x37, 0x00, 0x3C, 0x00,
      0x36, 0x00, 0x32, 0x00, 0x2F,
      0x00, 0x2C, 0x00, 0x29, 0x00,
      0x26, 0x00, 0x24, 0x00, 0x24,
      0x00, 0x23, 0x00, 0x3C, 0x00,
      0x36, 0x00, 0x32, 0x00, 0x2F,
      0x00, 0x2C, 0x00, 0x29, 0x00,
      0x26, 0x00, 0x24, 0x00, 0x24,
      0x00, 0x23, 0x00,

      WRITE_COMMAND_8, 0xC4,
      WRITE_BYTES, 26,
      0x62, 0x00, 0x05, 0x00, 0x84,
      0x00, 0xF0, 0x00, 0x18, 0x00,
      0xA4, 0x00, 0x18, 0x00, 0x50,
      0x00, 0x0C, 0x00, 0x17, 0x00,
      0x95, 0x00, 0xF3, 0x00, 0xE6,
      0x00,

      WRITE_COMMAND_8, 0xC5,
      WRITE_BYTES, 10,
      0x32, 0x00, 0x44, 0x00, 0x65,
      0x00, 0x76, 0x00, 0x88, 0x00,

      WRITE_COMMAND_8, 0xC6,
      WRITE_BYTES, 6,
      0x20, 0x00, 0x17, 0x00, 0x01,
      0x00,

      WRITE_COMMAND_8, 0xC7,
      WRITE_BYTES, 4,
      0x00, 0x00, 0x00, 0x00,

      WRITE_COMMAND_8, 0xC8,
      WRITE_BYTES, 4,
      0x00, 0x00, 0x00, 0x00,

      WRITE_COMMAND_8, 0xC9,
      WRITE_BYTES, 16,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00,

      WRITE_COMMAND_8, NT35310_3GAMMAR_CTRL_RED_P,
      WRITE_BYTES, 36,
      0x16, 0x00, 0x1C, 0x00, 0x21,
      0x00, 0x36, 0x00, 0x46, 0x00,
      0x52, 0x00, 0x64, 0x00, 0x7A,
      0x00, 0x8B, 0x00, 0x99, 0x00,
      0xA8, 0x00, 0xB9, 0x00, 0xC4,
      0x00, 0xCA, 0x00, 0xD2, 0x00,
      0xD9, 0x00, 0xE0, 0x00, 0xF3,
      0x00,

      // WRITE_COMMAND_8, NT35310_3GAMAR_CTRL_RED_N,
      // WRITE_BYTES, 36,
      // 0x16, 0x00, 0x1C, 0x00, 0x22,
      // 0x00, 0x36, 0x00, 0x45, 0x00,
      // 0x52, 0x00, 0x64, 0x00, 0x7A,
      // 0x00, 0x8B, 0x00, 0x99, 0x00,
      // 0xA8, 0x00, 0xB9, 0x00, 0xC4,
      // 0x00, 0xCA, 0x00, 0xD2, 0x00,
      // 0xD8, 0x00, 0xE0, 0x00, 0xF3,
      // 0x00,

      WRITE_COMMAND_8, NT35310_3GAMMAR_CTRL_GREEN_P,
      WRITE_BYTES, 36,
      0x05, 0x00, 0x0B, 0x00, 0x1B,
      0x00, 0x34, 0x00, 0x44, 0x00,
      0x4F, 0x00, 0x61, 0x00, 0x79,
      0x00, 0x88, 0x00, 0x97, 0x00,
      0xA6, 0x00, 0xB7, 0x00, 0xC2,
      0x00, 0xC7, 0x00, 0xD1, 0x00,
      0xD6, 0x00, 0xDD, 0x00, 0xF3,
      0x00,

      // WRITE_COMMAND_8, NT35310_3GAMMAR_CTRL_GREEN_N,
      // WRITE_BYTES, 36,
      // 0x05, 0x00, 0x0A, 0x00, 0x1C,
      // 0x00, 0x33, 0x00, 0x44, 0x00,
      // 0x50, 0x00, 0x62, 0x00, 0x78,
      // 0x00, 0x88, 0x00, 0x97, 0x00,
      // 0xA6, 0x00, 0xB7, 0x00, 0xC2,
      // 0x00, 0xC7, 0x00, 0xD1, 0x00,
      // 0xD5, 0x00, 0xDD, 0x00, 0xF3,
      // 0x00,

      WRITE_COMMAND_8, NT35310_3GAMMAR_CTRL_BLUE_P,
      WRITE_BYTES, 36,
      // 0x01, 0x00, 0x01, 0x00, 0x02,
      // 0x00, 0x2A, 0x00, 0x3C, 0x00,
      // 0x4B, 0x00, 0x5D, 0x00, 0x74,
      // 0x00, 0x84, 0x00, 0x93, 0x00,
      // 0xA2, 0x00, 0xB3, 0x00, 0xBE,
      // 0x00, 0xC4, 0x00, 0xCD, 0x00,
      // 0xD3, 0x00, 0xDD, 0x00, 0xF3,
      // 0x00,
      0x05, 0x00, 0x0B, 0x00, 0x1B,
      0x00, 0x34, 0x00, 0x44, 0x00,
      0x4F, 0x00, 0x61, 0x00, 0x79,
      0x00, 0x88, 0x00, 0x97, 0x00,
      0xA6, 0x00, 0xB7, 0x00, 0xC2,
      0x00, 0xC7, 0x00, 0xD1, 0x00,
      0xD6, 0x00, 0xDD, 0x00, 0xF3,
      0x00,

      // WRITE_COMMAND_8, NT35310_3GAMMAR_CTRL_BLUE_N,
      // WRITE_BYTES, 36,
      // 0x00, 0x00, 0x00, 0x00, 0x02,
      // 0x00, 0x29, 0x00, 0x3C, 0x00,
      // 0x4B, 0x00, 0x5D, 0x00, 0x74,
      // 0x00, 0x84, 0x00, 0x93, 0x00,
      // 0xA2, 0x00, 0xB3, 0x00, 0xBE,
      // 0x00, 0xC4, 0x00, 0xCD, 0x00,
      // 0xD3, 0x00, 0xDC, 0x00, 0xF3,
      // 0x00,

      WRITE_COMMAND_8, 0xE6,
      WRITE_BYTES, 32,
      0x11, 0x00, 0x34, 0x00, 0x56,
      0x00, 0x76, 0x00, 0x77, 0x00,
      0x66, 0x00, 0x88, 0x00, 0x99,
      0x00, 0xBB, 0x00, 0x99, 0x00,
      0x66, 0x00, 0x55, 0x00, 0x55,
      0x00, 0x45, 0x00, 0x43, 0x00,
      0x44, 0x00,

      WRITE_COMMAND_8, 0xE7,
      WRITE_BYTES, 32,
      0x32, 0x00, 0x55, 0x00, 0x76,
      0x00, 0x66, 0x00, 0x67, 0x00,
      0x67, 0x00, 0x87, 0x00, 0x99,
      0x00, 0xBB, 0x00, 0x99, 0x00,
      0x77, 0x00, 0x44, 0x00, 0x56,
      0x00, 0x23, 0x00, 0x33, 0x00,
      0x45, 0x00,

      WRITE_COMMAND_8, 0xE8,
      WRITE_BYTES, 32,
      0x00, 0x00, 0x99, 0x00, 0x87,
      0x00, 0x88, 0x00, 0x77, 0x00,
      0x66, 0x00, 0x88, 0x00, 0xAA,
      0x00, 0xBB, 0x00, 0x99, 0x00,
      0x66, 0x00, 0x55, 0x00, 0x55,
      0x00, 0x44, 0x00, 0x44, 0x00,
      0x55, 0x00,

      WRITE_COMMAND_8, 0xE9,
      WRITE_BYTES, 4,
      0xAA, 0x00, 0x00, 0x00,

      WRITE_C8_D8, 0x00, 0xAA,

      WRITE_COMMAND_8, 0xCF,
      WRITE_BYTES, 17,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00,

      WRITE_COMMAND_8, 0xF0,
      WRITE_BYTES, 5,
      0x00, 0x50, 0x00, 0x00, 0x00,

      WRITE_C8_D8, 0xF3, 0x00,

      WRITE_COMMAND_8, 0xF9,
      WRITE_BYTES, 4,
      0x06, 0x10, 0x29, 0x00,

      WRITE_C8_D8, NT35310_SET_PIXEL_FORMAT, 0x55, //66

      WRITE_COMMAND_8, NT35310_EXIT_SLEEP_MODE,
      END_WRITE,

      DELAY, NT35310_SLPOUT_DELAY,

      BEGIN_WRITE,
      WRITE_COMMAND_8, NT35310_SET_DISPLAY_ON,
      WRITE_C8_D8, NT35310_SET_TEAR_ON, 0x00,

      WRITE_C8_D8, NT35310_WRDISBV, 0xFF,
      WRITE_C8_D8, NT35310_WRCTRLD1, 0x2C,
      WRITE_C8_D8, NT35310_WRCTRLD2, 0x82,
      END_WRITE};

  _bus->batchOperation(nt35310_init_operations, sizeof(nt35310_init_operations));

  if (_ips)
  {
    _bus->sendCommand(NT35310_ENTER_INVERT_MODE);
  }
}
